'''
sophie module, version 0.1

(c) 2003-2018 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>
                                                                                
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

'''

from avlib import *
import socket,re

__all__ = ['sophie', 'trophie']

class sophie(ascanner):
  '''
  Sophie realscanner.

  This scanners is a realscanner, which can be used to scan
  for viruses. Sophie uses sophos libsavi. It can also be used
  for Trophie with TrendMicro antivirus scanner.

  If you need a chrooted sophie, copy it into chroot and start it
  from here. Do not forget to update it's chrooted database.
  
  Usage: sophie(sophie_socket,chroot_path='')

  Where: sophie_socket is a filename to sophie via UNIX socket
         chroot_path is a path, which you need to add
           (may be the same as your CHROOT, if you are using
           sagator in chroot and sophie not)
  '''
  name='sophie()'
  def __init__(self, scanner, chroot_path=''):
      self.scanner = scanner
      self.chroot = chroot_path
  def scanfile(self, files, dir='', args={}):
      level = 0.0
      detected = b''
      virlist = []
      s = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
      socket_settimeout(s, 120)
      s.connect(self.scanner)
      for fname in files:
        s.sendall(self.chroot+fname+'\n')
        ret=s.recv(256)
        debug.echo(4, self.name+': ', ret)
        if ret!='0':
          reg = re.search('^(-?[0-9]+):(.*)$', ret)
          if reg.group(1)=="1":
            level += 1.0
            virlist.append(fname+': '+reg.group(2)+'\n')
            if detected=='':
              detected = reg.group(2)
          if reg.group(1)=="-1":
            raise ScannerError(reg.group(2))
      return level, detected, virlist

class trophie(sophie):
  '''
  Trophie realscanner.
  
  It is an alias for sophie. See sophie documentation.
  '''
  name='trophie()'
