'''
Cache interscanners for sagator, version 1.0

(c) 2005-2016,2019 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
                                                                                
'''

from __future__ import absolute_import
                                                                                
from avlib import *
from .match import match_any
                                                                                
__all__ = ['cache']

class cache(match_any):
  '''
  Cache return value of a scanner.

  First call of this scanner caches return value for a scanner included into
  and return it's value. Next calls returns stored values.
  
  Usage: cache('VAR',scanners...)
  
  Where: 'VAR' is a string, which defines variable name to cache return value

  Example: cache('var1', scanner1()) # to store and return scanner1()'s value
           cache('var1') # to only return previously stored value
  
  New in version 0.7.0.
  '''
  name = 'cache()'
  VARA = {}
  def __init__(self, var, *scanners):
      self.var = var
      match_any.__init__(self, scanners)
  def reinit(self):
      match_any.reinit(self)
      if self.var in cache.VARA:
        del cache.VARA[self.var]
  def scanbuffer(self, buffer, args={}):
      if self.var in cache.VARA:
        return cache.VARA[self.var]
      else:
        level, detected, virlist = match_any.scanbuffer(self, buffer, args)
        cache.VARA[self.var] = level, detected, virlist
      return level, detected, virlist
