'''
A script used to extract almost all constants from C header files (*.h).

(c) 2007-2008 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or 
 (at your option) any later version.

'''

from __future__ import print_function

import re, sys

dspam_h = open('/usr/include/dspam/libdspam_objects.h', 'rt')

reg_define = re.compile(
  r'^#define\s+(DS[A-Z0-9a-z_]+)\s+(.*)$'
)

if len(sys.argv)>1:
  sys.stdout = open(sys.argv[1], 'wt')

print("""\
# This file is automatically generated by getconst.py.
""")
for line in dspam_h.readlines():
  # handle comments and trailing new lines
  line = line.strip().replace('/*', '#').replace('*/', '#')
  # search for #define line
  r = reg_define.search(line)
  if r:
    print("%s = %s" % r.groups())
