'''
bdc module - Bitdefender support, version 0.2

(c) 2003-2006 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>
                                                                                
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

'''

from avlib import *
import os,re

__all__=['bdc']

class bdc(ascanner):
  '''
  Bitdefender realscanner.
  
  This scanners is a realscanner, which can be used to scan
  for viruses. It parses Bitdefender output.

  Warning: If you are using bdc in chroot, don't forget to mount
           /proc directory under chroot.

  Usage: bdc(command=['/opt/bdc/bdc','--mail','--arc','--all'])

  Where: command is a array which defines command with parameters.
           By default: ['/opt/bdc/bdc','--mail','--arc','--all']
  '''
  name='bdc()'
  def __init__(self,command=['/opt/bdc/bdc','--mail','--arc','--all']):
      self.command=command
  def scanfile(self,files,dir='',args={}):
      level,detected,virlist,vir_count,ret=0.0,b'',[],0,[]
      if dir:
        pf=popen(self.command+[safe.fn(dir)])
      else:
        safe_files=[]
        for i in files:
          safe_files.append(safe.fn(i))
        pf=popen(self.command+safe_files)
      pf.tocmd.close()
      rc=pf.wait()
      # read lines from command
      while 1:
        line=pf.readline()
        if line=='': break
        if re.search("^Results:",line):
          while 1:
            line=pf.readline()
            if line=='': break
            if re.search("^Identified viruses:",line):
              vir_count=int(line[19:].strip())
          break
        if re.search("^Error: ",line):
          debug.echo(3,"ERROR: bdc(): ",line.strip())
        re1=re.search(" (inf|susp)ected: (.*)$",line.rstrip())
        if re1:
          if re1.group(1)=="inf": # if it is an indentified virus
            detected=re1.group(2)
            level+=1.0
          else:
            level+=0.9 # only suspected
            if detected=='': # if it is suspected, but no ident. virus
              detected=re1.group(2)
          ret.append(line)
      pf.fromcmd.close()
      debug.echo(4,"BDC: RET: ",[[vir_count,rc]],ret)
      return level, detected, virlist
