'''
sanitizer module, version 0.1

(c) 2003-2004,2019 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>
                                                                                
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

'''

from avlib import *

__all__ = ['sanitize']

class sanitize(ascanner):
  '''
  Sanitize (rename attachment filenames) an email.

  This scanners is a realscanner, which can be used to sanitize
  email. It means all attachments are renamed to safe names.
  For example "filename.exe" will be renamed to "filename-exe".
  
  WARNING! This scanner is in BETA stage! Id don't conform to RFC 2183!
  
  Usage: sanitize(insert='-',extensions='[a-z0-9]{3}')

  Where: insert is a string, which can be inserted for sanitized attachments
         extensions is an regular expressios to find
  '''
  name='sanitize()'
  def __init__(self, insert='-', extensions='[a-z0-9]{3}'):
      self.INS = insert
      re_flags = re.IGNORECASE|re.DOTALL
      self.re_content = re.compile(r'^ *Content-(Type|Disposition):', re_flags).search
      self.re_nocontent = re.compile(r'^\S', re_flags).search
      self.re_name1 = re.compile(r'(^.*name="[^"]*)\.('+extensions+'.*$)', re_flags).search
      self.re_name2 = re.compile(r'(^.*name=[^; ]*)\.('+extensions+'[; ].*$)', re_flags).search
  def scanbuffer(self, buffer, args={}):
      f = BytesIO(mail.data[mail.bodypos:])
      out = BytesIO()
      out.write(mail.data[mail.bodypos:])
      incontent = False
      while 1:
        line = f.readline()
        if not line:
          break
        if incontent:
          if self.re_nocontent(line):
            incontent = False
            if self.re_content(line):
              line = self.check(line)
            out.write(line)
            continue
          line = self.check(line)
        else:
          if self.re_content(line):
            incontent = True
            line = self.check(line)
        out.write(line)
      mail.data = out.getvalue()
      # return CLEAN, because sanitizer can't detect a virus
      return 0.0, b'', []
  def check(self, line):
      r1 = self.re_name1(line)
      if r1:
        return r1.group(1)+self.INS+r1.group(2)
      r2 = self.re_name2(line)
      if r2:
        return r2.group(1)+self.INS+r2.group(2)
      return line
