'''
collector.py - statistics collector service for sagator

(c) 2003-2008 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

'''

from aglib import *
import stats

__all__ = ['collector']

class collector(service):
  '''
  Statistics collector service.
  
  This service can be used to collect some data for statistics.
  
  Usage: collector(ip_or_hostname='', port=-1,
                   statfile='/var/lib/sagator/status')
  
  Where: ip_or_hostname is an string, which defines IP to bind to
         port is an integer, which defines port number to bind to.
           If port<0 (default), no tcp socket will listen and only
           statistics from file will be processed. It is effective
           for large servers.
         statfile is an string, which defines where to store status
  
  Examples: collector()
        or: collector('0.0.0.0',28)
  '''
  name='collector()'
  def __init__(self, host='', port=-1, statfile='/var/lib/sagator/status'):
      if port<0:
        self.BINDTO = ()
      else:
        self.BINDTO = (host,port)
      self.STATFILE = statfile
      self.MIN_CHILDS = 0
  def start(self):
      globals.stat_coll = stats.collector(self.BINDTO,self.STATFILE)
      pid = globals.stat_coll.start()
      if pid>0:
        self.childs = [pid]
        return [pid]
      else:
        return []
