'''
example.py - An example service for sagator.

(c) 2004 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

'''

import re
from aglib import *

__all__=['srv_example']

class srv_example(service):
  '''
  Example service for sagator.
  
  This service can be used as an template to write your own service.
  
  Usage: srv_example(scanners, parameters)
  
  Where: scanners is an array of scanners (see README.scanners for more info)
         parameters is ...

  Example: srv_example(SCANNERS, parameters)
  '''
  
  # Define this service name here. Service name must end with ().
  name='srv_example()'
  
  # This method is called from sagator's config file.
  # You can define some parameters, which are required for this service.
  def __init__(self,scanners,parameters='Default'):
      # You can only store these parameters. This code can't do
      # anything else. For more examples see service class from aglib.py.
      self.SCANNERS=scanners
      self.parameters=parameters
  def start(self):
      # This method is called from sagator's main process.
      # You can fork some processes here and then this method must
      # return.
      # Return value: array of forked pids
      return []
  def accept(self,connects=0):
      # accept method is required only if you are using preforking core
      # from default service (default service.start() function).

      # accept connection
      conn,addr = self.s.accept()
      # you need to reinit scanners before a scan
      for scnr in self.SCANNERS:
        scnr.reinit()
      # also need to reset global class
      globals.reset()
      
      # you need to store data into mail class
      mail.data='........'
      # now you can use checkvir() function to check for viruses
      stat,level,virname=checkvir(self.SCANNERS)
      # and test it's return values
      if stat==S_OK:
        # It's clean.
        pass
      elif stat==S_FORCE_SEND:
        # It contains a virus, but it's requested to send this email
        # to recipients.
        pass
      elif stat==S_REJECT:
        # You need to reject this email.
        pass
      elif stat==S_DROP:
        # You need to drop this email.
        pass
      elif stat==S_TEMPFAIL:
        # An temporary error occured, send 4XX error code over SMTP.
        pass
      # now you need to safely shutdown this connection
      try:
        conn.shutdown(socket.SHUT_RDWR)
      except socket.error:
        pass
      # and close this connection
      conn.close()
  # Following methods are not required. They are called from default
  # service main method.
  def fork(self):
      # fork a new process
      pass
  def sighup(self,sn,stack):
      # HUP signal received
      pass
  def sigchld(self,sn,stack):
      # an child exited
      pass
  def sigterm(self,sn,stack):
      # TERM signal received
      pass
