# Create postfix configuration for SAGATOR

RELOAD=""

if grep -q "^#begin: sagator" /etc/postfix/main.cf >/dev/null; then
  echo "Postfix main configuration already done."
else
  echo "Autoconfiguring postfix main.cf ..."
  echo -e \
    "#begin: sagator\ncontent_filter=smtp:[127.0.0.1]:27\n#end: sagator\n" \
    >> /etc/postfix/main.cf
  RELOAD=1
fi
if grep -q "^#begin: sagator" /etc/postfix/master.cf >/dev/null; then
  echo "Postfix master configuration already done."
else
  echo "Autoconfiguring postfix master.cf ..."
  cat >> /etc/postfix/master.cf << EOF
#begin: sagator
127.0.0.1:26	inet n - n - 30 smtpd
  -o content_filter=
  -o myhostname=sagator.`hostname`
  -o in_flow_delay=0
  -o local_recipient_maps=  -o relay_recipient_maps=
  -o mynetworks=127.0.0.0/8  -o mynetworks_style=host
  -o smtpd_restriction_classes=  -o smtpd_client_restrictions=
  -o smtpd_helo_restrictions=  -o smtpd_sender_restrictions=
  -o smtpd_data_restrictions=
  -o smtpd_recipient_restrictions=permit_mynetworks,reject
  -o receive_override_options=no_unknown_recipient_checks,no_header_body_checks
  -o smtpd_use_tls=no
  -o smtpd_milters=
sagator         unix - - n - 8 smtp
  -o smtp_data_done_timeout=1200
  -o smtp_send_xforward_command=yes
  -o disable_dns_lookups=yes
  -o max_use=20
#end: sagator
EOF
  RELOAD=1
fi

if [ -x /usr/sbin/semanage ]; then
  # add port 26 to allowed ports for selinux
  /usr/sbin/semanage port -a -t smtp_port_t -p tcp 26
fi

if [ "$RELOAD" ]; then
  # reload postfix
  if [ -x /bin/systemctl ]; then
    systemctl restart postfix.service
  else
    /etc/init.d/postfix reload || true
  fi
fi
