'''
libclamav - clamav python module
 
(c) 2008-2018 Jan ONDREJ (SAL) <ondrejj(at)salstar.sk>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
'''

from __future__ import absolute_import

import os
from ctypes import *
from ctypes.util import find_library
from .shared import ClamAVError

def clamav(solib=None, *args, **kw):
    if not solib:
      solib = find_library('clamav')
    if not solib:
      raise ClamAVError('ClamAV library not found!')
    libver = int(os.path.basename(solib).split('.')[2])
    if libver>=9:
      from . import libso9 as libso
    elif libver>=6:
      # libclamav.so.7 is compatible with previous version
      from . import libso6 as libso
    else:
      raise ClamAVError("Unsupported library: '%s'" % solib)
    so = cdll.LoadLibrary(solib)
    return libso.clamav(so, *args, **kw)
